﻿using System;
using Rglib.Interop;

namespace rglib.libtest {
    public class CodogrammPriorityProxy : BindingProxy<RG_CODOGRAMM_PRIORITY> {
        public CodogrammPriorityProxy(RG_CODOGRAMM_PRIORITY wrappedObject) : base(wrappedObject) {
        }

        public byte PriorityValue => (byte) Object;

        public override string ToString() {
            switch (Object) {
                case RG_CODOGRAMM_PRIORITY.CPE_BACKGROUND:
                    return "Фоновая индикация";
                case RG_CODOGRAMM_PRIORITY.CPE_CYCLIC_LO:
                    return "Циклическая";
                case RG_CODOGRAMM_PRIORITY.CPE_CYCLIC_HI:
                    return "Циклическая приор.";
                case RG_CODOGRAMM_PRIORITY.CPE_ONCE_LO:
                    return "Разовая";
                case RG_CODOGRAMM_PRIORITY.CPE_ONCE_HI:
                    return "Разовая приор.";
                default:
                    return "Неизвестно";
            }
        }

        public override bool Equals(BindingProxy<RG_CODOGRAMM_PRIORITY> other)
        {
            return other != null && Object == other.Object;
        }
    }


    public class Codogramm {
        private byte _lengthBits = 32;
        private byte _number = 1;
        private uint _codogrammBody = 0x0f0ff0f0;

        public string Name { get; set; }

        public byte Number {
            get => _number;
            set => _number = value;
        }

        public byte LengthBits {
            get => _lengthBits;
            set {
                byte localValue = value;

                if (localValue < 2)
                    localValue = 2;
                if (localValue > 32)
                    localValue = 32;
                _lengthBits = localValue;
            }
        }

        public uint CodogrammBody {
            get => _codogrammBody;
            set => _codogrammBody = value;
        }

        public override string ToString() {
            return $"{Number} {(string.IsNullOrEmpty(Name) ? "<noname>" : Name)}";
        }

        internal void UdpateFrom(Codogramm other) {
            if (other == null)
                throw new ArgumentNullException(nameof(other));

            _lengthBits = other.LengthBits;
            _number = other.Number;
            _codogrammBody = other.CodogrammBody;
        }
    }
}