﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Rglib.Interop;

namespace rglib.libtest
{
    public partial class FindDevicesForm : Form {
        private BindingList<Reader> _readers;

        public FindDevicesForm() {
            InitializeComponent();

            // список считок
            _readers = new BindingList<Reader>();
            dataGridView1.AutoGenerateColumns = false;
            dataGridView1.MultiSelect = false;

            dataGridView1.DataSource = _readers;

        }

        private void TryToUpdateDevicesList() {
            DisableControls();

            _readers.Clear();
            //foundDevicesList.Refresh();

            IntPtr devicesListHandle = IntPtr.Zero;
            uint foundDevicesCount = 0;

            if (Methods.RG_FindDevices(ref devicesListHandle, RG_ENDPOINT_TYPE.CTE_USBHID | RG_ENDPOINT_TYPE.CTE_SERIAL, ref foundDevicesCount) == 0) {
                try {
                    if (foundDevicesCount > 0) {
                        RG_ENDPOINT_INFO endpointInfo = new RG_ENDPOINT_INFO();
                        foreach (uint foundDeviceIndex in Enumerable.Range(0, Convert.ToInt32(foundDevicesCount))) {
                            RG_DEVICE_INFO_EXT deviceInfo = new RG_DEVICE_INFO_EXT();

                            if (Methods.RG_GetFoundDeviceInfo(devicesListHandle, foundDeviceIndex, ref endpointInfo,
                                    ref deviceInfo) == 0) {
                                _readers.Add(new Reader(
                                    new RG_ENDPOINT {Type = endpointInfo.Type, Address = endpointInfo.Address},
                                    deviceInfo));
                            }
                        }
                    }
                }
                finally {
                    if (devicesListHandle != IntPtr.Zero) {
                        Methods.RG_CloseResource(devicesListHandle);
                    }
                }
            }

            EnableControls();
        }

        private void DisableControls() {
            dataGridView1.Enabled = false;
            findDevicesButton.Enabled = false;
            connectDeviceButton.Enabled = false;
            closeButton.Enabled = false;
        }

        private void EnableControls() {
            dataGridView1.Enabled = true;
            findDevicesButton.Enabled = true;
            connectDeviceButton.Enabled = true;
            closeButton.Enabled = true;
        }

        private void FindDevicesButtonClick(object sender, EventArgs e) {
            TryToUpdateDevicesList();
        }

        private void CloseButtonClick(object sender, EventArgs e) {
            Close();
        }

        private void ConnectButtonClick(object sender, EventArgs e) {
            if (dataGridView1.SelectedRows.Count > 0) {
                DoInteractWith(dataGridView1.CurrentRow.DataBoundItem as Reader);               
            }
            else {
                MessageBox.Show("Не выбрано ни одного устройства");
            }
        }

        private void DoInteractWith(Reader reader) {
            using (var interactionForm = new DeviceInteractionForm(reader))
            {
                interactionForm.StartPosition = FormStartPosition.CenterScreen;
                interactionForm.ShowDialog(this);
            }
        }

        private void OnClosing(object sender, FormClosingEventArgs e) {
            if (DialogResult != DialogResult.OK) {
                foreach (Reader reader in _readers) {
                    RG_ENDPOINT readerEndpoint = reader.Endpoint;
                    Methods.RG_CloseDevice(ref readerEndpoint, reader.Address);
                }
            }
        }

        private void OnLoad(object sender, EventArgs e) {
            //Methods.RG_InitializeLib(1);
        }

        private void GridDoubleClick(object sender, DataGridViewCellEventArgs e) {
            if (dataGridView1.SelectedRows.Count >= 0) {
                DoInteractWith(dataGridView1.CurrentRow.DataBoundItem as Reader);
            }
        }
    }
}
