﻿using Rglib.Interop;

namespace rglib.libtest {
    public class CardFamilyProxy : BindingProxy<RG_CARD_FAMILY_CODE> {
        public CardFamilyProxy(RG_CARD_FAMILY_CODE wrappedObject) : base(wrappedObject) {
        }

        public byte Code => (byte) Object;

        public override string ToString() {
            switch (Object) {
                case RG_CARD_FAMILY_CODE.CFCE_PIN:
                    return "PIN";
                case RG_CARD_FAMILY_CODE.CFCF_TEMIC:
                    return "Temic";
                case RG_CARD_FAMILY_CODE.CFCE_HID:
                    return "HID";
                case RG_CARD_FAMILY_CODE.CFCE_EM:
                    return "Em-Marine";
                case RG_CARD_FAMILY_CODE.CFCF_INDALA:
                    return "Indala";
                case RG_CARD_FAMILY_CODE.CFCE_COTAG:
                    return "Cotag";
                case RG_CARD_FAMILY_CODE.CFCE_MIFARE:
                    return "Mifare";
                default:
                    return "Неизвестно";
            }
        }

        public override bool Equals(BindingProxy<RG_CARD_FAMILY_CODE> other)
        {
            return other != null && Object == other.Object;
        }
    }
}